import Utilities.gui_creator as gc
import mcculw.ul as mu
import mcculw.enums as me

board_num, channel = 0, 0
ai_range = me.ULRange.BIP10VOLTS

root = gc.create_window(title='DC Voltmeter',
                        size='250x100')

lbl_2 = gc.create_indicator(root,
                            label_1='Voltage Reading (V)')


def acquire_sample():
    
    float_data = mu.v_in(board_num, channel, ai_range)
    string_data = str(float_data)
#    string_data = f'{float_data:.3f}'

    lbl_2.config(text=string_data)

    return

btn = gc.action_button(root, label='Read Sample',
                       action=acquire_sample)

root.mainloop()
